unit Ncopydlg;

interface

uses 
     SysUtils,
     WinTypes, 
     WinProcs, 
     Classes, 
     Graphics, 
     Forms, 
     Controls, 
     Buttons,
     StdCtrls, 
     ExtCtrls, 
     Dialogs, 
     Nwtools, Nwlib;

type
  TwinNCopyDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    inFile: TEdit;
    outFile: TEdit;
    openBtn: TSpeedButton;
    saveBtn: TSpeedButton;
    Label1: TLabel;
    Label2: TLabel;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    procedure openBtnClick(Sender: TObject);
    procedure saveBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  winNCopyDlg: TwinNCopyDlg;

implementation

{$R *.DFM}

procedure TwinNCopyDlg.openBtnClick(Sender: TObject);
  begin
    openDialog1.initialDir := setPath(extractFilePath(inFile.text)) +
                              extractFileName(inFile.text);
    if opendialog1.execute then
      begin
        inFile.text := openDialog1.fileName;
        outFile.setFocus ;
      end;
  end;

procedure TwinNCopyDlg.saveBtnClick(Sender: TObject);
  begin
    saveDialog1.initialDir := setPath(extractFilePath(outFile.text))  ;
    if saveDialog1.execute then
      begin
        outFile.text := saveDialog1.fileName;
        okBtn.setFocus ;
      end;
  end;

procedure TwinNCopyDlg.OKBtnClick(Sender: TObject);
  var
    ctemp : string ;
  begin
    try
      ctemp := outfile.text ;
      if fileExists(ctemp) and 
          noYesBox(ctemp + ';Already Exists;;Overwrite Existing File?') then
        {$IFDEF WIN32}
          deleteFile(PChar(ctemp)) ;
        {$ELSE}
          deleteFile(ctemp) ;
        {$ENDIF}
      if (not fileExists(ctemp)) then
        begin
          if nCopy(inFile.text,ctemp) then
            okbox(infile.text + ';' + ctemp + ';;File Copied Successfully') 
          else
            alertBox(infile.text + ';' + ctemp + ';;File Not Copied!') ;
        end;
    except
      on exception do
        alertBox('Error Copying File;;Check Source/Destination Pathnames') ;
    end;
  end;

procedure TwinNCopyDlg.FormClose(Sender: TObject; var Action: TCloseAction);
  begin
    action := caFree ;
  end;

end.
